/* ******************************************************************
GAUSS code: Exercise 1.8(c)
File: kurtosis.g

Reference:
Bai, J. and Ng, S. (2005).
   Tests for skewness, kurtosis, and normality for time series 
   data.
   Journal of Business & Economic Statistics, 23(1), 49-60.
   DOI: 10.1198/073500104000000271.
******************************************************************** */
proc(1)=kurtosis(x,k0,prewhite,kernel);
local xbar,m3,se,sig,n,a,m2,m4,m5,m6,std,z,stat,omega,vv,stat1,stat2,stat3;
local stat1a,stat2a;

a    = ones(3,1);
xbar = meanc(x);
z    = x-xbar;
n    = rows(x);

m2 = sumc(z^2)/(n-1);
m3 = sumc(z^3)/(n-1);
m4 = sumc(z^4)/(n-1);
m5 = sumc(z^5)/(n-1);
m6 = sumc(z^6)/(n-1);

omega = zeros(2,2);
vv    = (z^4-m2^2)~z~(z^2-m2);

if kernel == 1; omega=parzen(vv,prewhite);endif;
if kernel == 2; omega=nw(vv,prewhite);endif;
if kernel == 3; omega=qs(vv,prewhite);endif;

a[1] = 1;
a[2] = -4*m3;
a[3] = -2*m2*k0;

se     = sqrt(a'omega*a/(m2^4))/sqrt(n);
stat3  = m4/(m2^2);
stat1  = (stat3-k0)/se;
stat1a = maxc(k0|stat3)*(log(stat3)-log(k0))/se;
a[3]   = -2*m2*3;
se     = sqrt(a'omega*a/(m2^4))/sqrt(n);
stat2  = (stat3-3)/se;
stat2a = maxc(3|stat3)*(log(stat3)-log(3))/se;

retp(stat1~stat2~stat3);
endp;
